<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van QUMT_IN900014NL - Signal Notification</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>

    <include href="coreschematron/xml.sch"/>
    <include href="coreschematron/attentionLine.sch"/>
    
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <!--pattern is-a="attentionLine" id="QUMT_IN900014NL-attentionLine">
        <param name="messagePatientId" value="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:subject2/hl7:CategoryEvent/hl7:recordTarget/hl7:Patient/hl7:id"/>
        </pattern-->
    
    <pattern is-a="transmission-wrapper" id="QUMT_IN900014NL-wrapper">
        <param name="element" value="hl7:QUMT_IN900014NL"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="QUMT_IN900014NL-controlAct">
        <param name="element" value="hl7:QUMT_IN900014NL/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:QUMT_IN900014NL/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:QUMT_IN900014NL/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
        <rule context="hl7:QUMT_IN900014NL/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>Zender en ontvanger</title>
        <rule context="hl7:QUMT_IN900014NL/hl7:sender/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >De zender van deze interactie moet de ZIM zijn</assert>
        </rule>
        <rule context="hl7:QUMT_IN900014NL/hl7:receiver/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"
                >De ontvanger van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subscriptionEvent</title>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:subscriptionEvent/hl7:id">
            <extends rule="II"/>
        </rule>
        
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:subscriptionEvent/hl7:code">
            <extends rule="CV"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.3.11.12' and @code"
                >subscriptionEvent/code/@codesystem moet '2.16.840.1.113883.2.4.3.11.12' zijn</assert>
        </rule>
        
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:subscriptionEvent/hl7:effectiveTime">
            <extends rule="IVL_TS"/>
            <assert role="error" test="hl7:high/@value and count(*) = 1 and ((@xsi:type and count(@*)=1) or count(@*)=0)"
                >subscriptionEvent/effectiveTime/high/@value moet een waarde bevatten en er mogen geen andere elementen of attributen zijn gevuld</assert>
            <assert role="error" test="matches(hl7:high/@value,'^[0-9]{12}')"
                >subscriptionEvent/effectiveTime/value/high/@value moet tenminste tot op de minuten zijn gespecificeerd</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subscriptionEvent/reasonOf/controlActEvent</title>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:subscriptionEvent/hl7:reasonOf/hl7:controlActEvent">
            <assert test="hl7:subject1 or hl7:subject2"
                >tenminste één van subject1 of subject2 moet aanwezig zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subscriptionEvent/reasonOf/controlActEvent/subject1</title>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:subscriptionEvent/hl7:reasonOf/hl7:controlActEvent/hl7:subject1/hl7:assignedEntity/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.3' or @root='2.16.528.1.1007.3.1' or @root='2.16.528.1.1007.3.3'"
                >subscriptionEvent/subject1/assignedEntity/id/@root moet de waarde '2.16.840.1.113883.2.4.6.3' (BSN), '2.16.528.1.1007.3.1' (UZI), of '2.16.528.1.1007.3.3' (URA) bevatten</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subscriptionEvent/reasonOf/controlActEvent/author</title>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:subscriptionEvent/hl7:reasonOf/hl7:controlActEvent/hl7:author">
            <assert role="error" test="hl7:assignedPerson/hl7:id"
                >assignedPerson/id is verplicht</assert>
            <assert role="error" test="hl7:assignedPerson/hl7:code"
                >assignedPerson/code is verplicht</assert>
            <assert role="error" test="hl7:assignedPerson/hl7:telecom"
                >assignedPerson/telecom is verplicht</assert>
            <assert role="error" test="hl7:assignedPerson/hl7:Organization/hl7:id"
                >assignedPerson/Organization/id is verplicht</assert>
        </rule>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:subscriptionEvent/hl7:reasonOf/hl7:controlActEvent/hl7:author/hl7:assignedPerson/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.528.1.1007.3.1' and @extension"
                >assignedPerson/id/@root moet '2.16.528.1.1007.3.1' zijn en @extension moet een geldige waarde bevatten</assert>
        </rule>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:subscriptionEvent/hl7:reasonOf/hl7:controlActEvent/hl7:author/hl7:assignedPerson/hl7:code">
            <extends rule="CE"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.15.111' and @code"
                >assignedPerson/code/@codeSystem moet '2.16.840.1.113883.2.4.15.111' zijn en @code moet een geldige waarde bevatten</assert>
        </rule>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:subscriptionEvent/hl7:reasonOf/hl7:controlActEvent/hl7:author/hl7:assignedPerson/hl7:telecom">
            <extends rule="TEL"/>
            <assert role="error" test="substring(@value,1,43)='x-hl7-applicatie:2.16.840.1.113883.2.4.6.6.'"
                >assignedPerson/telecom moet een AORTA applicatie-id zijn</assert>
        </rule>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:subscriptionEvent/hl7:reasonOf/hl7:controlActEvent/hl7:author/hl7:assignedPerson/hl7:Organization/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.528.1.1007.3.3' and @extension"
                >assignedPerson/Organization/id/@root moet '2.16.528.1.1007.3.3' zijn en @extension moet een geldige waarde bevatten</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subscriptionEvent/reasonOf/controlActEvent/subject2</title>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:subscriptionEvent/hl7:reasonOf/hl7:controlActEvent/hl7:subject2/hl7:registrationEvent/hl7:code">
            <extends rule="CD"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.15.4' or @codeSystem='2.16.840.1.113883.6.1'"
                >registrationEvent/code moet komen uit ActRegistrycodeNL (2.16.840.1.113883.2.4.15.4) of LOINC (2.16.840.1.113883.6.1).</assert>
        </rule>
    </pattern>
 </schema>
